% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/switchde.R
\name{fit_nzi_model}
\alias{fit_nzi_model}
\title{Fit a (non-zero-inflated) model for a single gene}
\usage{
fit_nzi_model(y, pst)
}
\arguments{
\item{y}{Vector of gene expression values}

\item{pst}{Pseudotime vector, of same length as y}
}
\value{
A vector with 5 entries: maximum likelihood estimates for \eqn{\mu_0}, \eqn{k}
\eqn{t0}, \eqn{\sigma^2} and a p-value
}
\description{
Fits a sigmoidal expression model for a single gene vector, returning
MLE model parameters and p-value.
}
\examples{
data(synth_gex)
data(ex_pseudotime)
y <- synth_gex[1, ]
fit <- fit_nzi_model(y, ex_pseudotime)
}
