% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/stato_class.R
\name{stato_id}
\alias{stato_id}
\alias{stato_name}
\alias{stato_definition}
\alias{stato_summary}
\alias{stato}
\alias{stato_id,stato-method}
\alias{stato_name,stato-method}
\alias{stato_definition,stato-method}
\alias{stato_summary,stato-method}
\title{get the stato_id for an object}
\usage{
stato_id(obj)

stato_name(obj)

stato_definition(obj)

stato_summary(obj)

stato(stato_id)

\S4method{stato_id}{stato}(obj)

\S4method{stato_name}{stato}(obj)

\S4method{stato_definition}{stato}(obj)

\S4method{stato_summary}{stato}(obj)
}
\arguments{
\item{obj}{An object derived from the stato object}

\item{stato_id}{A STATO ID e.g. OBI:0000001}
}
\value{
id the stato id

name the stato name

def the stato description

Value returned depends on the method used.
}
\description{
A base class in the \pkg{struct} package. Provides several fundamental
methods and should not be called directly.
}
\details{
STATO is the statistical methods ontology. It contains concepts and
properties related to statistical methods, probability distributions and
other concepts related to statistical analysis, including relationships to
study designs and plots (see \href{http://stato-ontology.org/}{
http://stato-ontology.org/}).

This class provides access to a version of the STATO ontology database that
can be searched by ontology id to provide formal names and definitions for
methods, models, iterators, metrics and charts.

This class makes use of the \code{ontologyIndex} package to search a copy of
the STATO database included in this package.
}
\examples{
M = example_model()
stato_id(M)
stato_name(M)
stato_definition(M)
stato_summary(M)
# an example stato object
M = example_model()

# the stato id assigned to object M
stato_id(M) # OBI:0000011

# the name associated with that id
stato_name(M)

# the STATO definition for that id
stato_definition(M)

# a summary of the STATO database entry for the id, and any parameters or
# outputs that also have stato ids.
stato_summary(M)

}
