% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enum_class.R
\name{enum}
\alias{enum}
\alias{value<-,enum-method}
\title{Enum objects}
\usage{
enum(
  name,
  description = character(0),
  type = "character",
  value = character(0),
  max_length = 1,
  allowed,
  ...
)

\S4method{value}{enum}(obj) <- value
}
\arguments{
\item{name}{the name of the object}

\item{description}{a description of the object}

\item{type}{the type of the struct object}

\item{value}{value of the enum}

\item{max_length}{Maximum length of value vector (default 1)}

\item{allowed}{A list of allowed values}

\item{...}{additional inputs to the struct_class object}

\item{obj}{an enum object}
}
\value{
an enum object
}
\description{
A base class in the \pkg{struct} package. Not normally called directly.
}
\details{
An enum object is a special type of entity object that ensures the value must
be one from a list of allowed values.

Enum objects are usually defined in the prototype of another object, but
can be extracted using \code{param_obj} and \code{output_obj}.
}
\examples{
# Create a new enum object
E = enum(
    name = 'example',
    description = 'this is an example',
    type = 'character',
    value = 'hello',
    allowed = c('hello','world')
)

# Get/set the value of the entity object
value(E)
value(E) = 'world'
}
