% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample_class.R
\name{resample}
\alias{resample}
\title{Data resampling}
\usage{
resample(
  number_of_iterations = 10,
  method = "split_data",
  factor_name,
  p_train = 0.8,
  collect = NULL,
  ...
)
}
\arguments{
\item{number_of_iterations}{(numeric, integer) The number of training sets to generate. The default is \code{10}.\cr}

\item{method}{(character) Resampling method. Allowed values are limited to the following: \itemize{ \item{\code{"split_data"}: Samples for the training set are selected at random from the full dataset.}\item{\code{"stratified_split"}: Samples for the training set are randomly selected from each level of the chosen factor.}\item{\code{"equal_split"}: Samples for the training set are selected at random from each level of the main factor such that all group sizes are equal.}} The default is \code{"split_data"}.}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{p_train}{(numeric) The proportion of samples selected for the training set. The default is \code{0.8}.\cr}

\item{collect}{(NULL, character) The name of a model output to collect over all bootstrap repetitions, in addition to the input metric. The default is \code{NULL}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{resample} object with the following \code{output} slots:
\tabular{ll}{
\code{results.training} \tab          (data.frame)  \cr
\code{results.testing} \tab          (data.frame)  \cr
\code{metric} \tab          (data.frame)  \cr
\code{collected} \tab          (list)  \cr
\code{metric.train} \tab          (numeric)  \cr
\code{metric.test} \tab          (numeric)  \cr
}
}
\description{
New training sets are generated from the original data by selecting samples at random. This can be based on levels in a factor or on the whole dataset.
}
\section{Inheritance}{

A \code{resample} object inherits the following \code{struct} classes: \cr\cr
\verb{[resample]} >> \verb{[resampler]} >> \verb{[iterator]} >> \verb{[struct_class]}
}

\examples{
M = resample(
      number_of_iterations = 100,
      method = "split_data",
      factor_name = "V1",
      p_train = 0.75,
      collect = NULL)

I = resample(
    number_of_iterations = 10, 
    factor_name = 'Species', 
    method = 'split_data',
    p_train = 0.8)
}
