% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kw_rank_sum_class.R
\name{kw_rank_sum}
\alias{kw_rank_sum}
\title{Kruskal-Wallis rank sum test}
\usage{
kw_rank_sum(alpha = 0.05, mtc = "fdr", factor_names, ...)
}
\arguments{
\item{alpha}{(numeric) The p-value cutoff for determining significance. The default is \code{0.05}.\cr}

\item{mtc}{(character) Multiple test correction method. Allowed values are limited to the following: \itemize{ \item{\code{"bonferroni"}: Bonferroni correction in which the p-values are multiplied by the number of comparisons.}\item{\code{"fdr"}: Benjamini and Hochberg False Discovery Rate correction.}\item{\code{"none"}: No correction.}} The default is \code{"fdr"}.}

\item{factor_names}{(character) The name of sample meta column(s) to use.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{kw_rank_sum} object with the following \code{output} slots:
\tabular{ll}{
\code{test_statistic} \tab          (data.frame) The value of the calculated statistic which is converted to a p-value when compared to a chi2-distribution. \cr
\code{p_value} \tab          (data.frame) The probability of observing the calculated statistic. \cr
\code{dof} \tab          (numeric) The number of degrees of freedom used to calculate the test statistic. \cr
\code{significant} \tab          (data.frame) TRUE if the calculated p-value is less than the supplied threhold (alpha). \cr
\code{estimates} \tab          (data.frame)  \cr
}
}
\description{
The Kruskal-Wallis test is a univariate hypothesis testing method that allows multiple (n>=2) groups to be compared without making the assumption that values are normally distributed. It is the non-parametric equivalent of a 1-way ANOVA. The test is applied to all variables/features individually, and multiple test corrected p-values are computed to indicate the significance of variables/features.
}
\section{Inheritance}{

A \code{kw_rank_sum} object inherits the following \code{struct} classes: \cr\cr
\verb{[kw_rank_sum]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = kw_rank_sum(
      alpha = 0.05,
      mtc = "fdr",
      factor_names = "V1")

D = iris_DatasetExperiment()
M = kw_rank_sum(factor_names='Species')
M = model_apply(M,D)
}
