% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constant_sum_norm_class.R
\name{constant_sum_norm}
\alias{constant_sum_norm}
\title{Normalisation to constant sum}
\usage{
constant_sum_norm(scaling_factor = 1, ...)
}
\arguments{
\item{scaling_factor}{(numeric) The scaling factor applied after normalisation. The default is \code{1}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{constant_sum_norm} object with the following \code{output} slots:
\tabular{ll}{
\code{normalised} \tab          (DatasetExperiment) A DatasetExperiment object containing the normalised data. \cr
\code{coeff} \tab          (data.frame) The sum of each row, used to normalise the samples. \cr
}
}
\description{
Each sample is normalised such that the total signal is equal to one (or a scaling factor if specified).
}
\section{Inheritance}{

A \code{constant_sum_norm} object inherits the following \code{struct} classes: \cr\cr
\verb{[constant_sum_norm]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = constant_sum_norm(
      scaling_factor = 1)

M = constant_sum_norm()

}
