% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_chart_classes.R
\name{compare_dist}
\alias{compare_dist}
\title{Compare distributions}
\usage{
compare_dist(factor_name, ...)
}
\arguments{
\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{
compare_dist
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to plot this chart object.
}
\description{
Histograms and boxplots computed across samples and features are used to visually compare two datasets e.g. before and after filtering and/or normalisation.
}
\section{Inheritance}{

A \code{compare_dist} object inherits the following \code{struct} classes: \cr\cr
\verb{[compare_dist]} >> \verb{[chart]} >> \verb{[struct_class]}
}

\examples{
M = compare_dist(
      factor_name = "V1")

D1=MTBLS79_DatasetExperiment(filtered=FALSE)
D2=MTBLS79_DatasetExperiment(filtered=TRUE)
C = compare_dist(factor_name='Class')
chart_plot(C,D1,D2)
}
