% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_class.R
\name{bootstrap}
\alias{bootstrap}
\title{Bootstrap resampling}
\usage{
bootstrap(number_of_repetitions = 100, collect, ...)
}
\arguments{
\item{number_of_repetitions}{(numeric, integer) The number of bootstrap repetitions. The default is \code{100}.\cr}

\item{collect}{(character) The name of a model output to collect over all bootstrap repetitions, in addition to the input metric.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{bootstrap} object with the following \code{output} slots:
\tabular{ll}{
\code{results} \tab          (data.frame)  \cr
\code{metric} \tab          (data.frame)  \cr
\code{collected} \tab          (logical, list)  \cr
}
}
\description{
In bootstrap resampling a subset of samples is selected at random with replacement to form a training set. Any sample not selected for training is included in the test set. This process is repeated many times, and performance metrics are computed for each repetition.
}
\section{Inheritance}{

A \code{bootstrap} object inherits the following \code{struct} classes: \cr\cr
\verb{[bootstrap]} >> \verb{[resampler]} >> \verb{[iterator]} >> \verb{[struct_class]}
}

\examples{
M = bootstrap(
      number_of_repetitions = 10,
      collect = "vip")

I = bootstrap(number_of_repetitions = 10, collect = 'vip')
}
