% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HSDEM_class.R
\name{HSDEM}
\alias{HSDEM}
\title{Tukey's Honest Significant Difference using estimated marginal means}
\usage{
HSDEM(alpha = 0.05, mtc = "fdr", formula, ...)
}
\arguments{
\item{alpha}{(numeric) The p-value cutoff for determining significance. The default is \code{0.05}.\cr}

\item{mtc}{(character) Multiple test correction method. Allowed values are limited to the following: \itemize{ \item{\code{"bonferroni"}: Bonferroni correction in which the p-values are multiplied by the number of comparisons.}\item{\code{"fdr"}: Benjamini and Hochberg False Discovery Rate correction.}\item{\code{"none"}: No correction.}} The default is \code{"fdr"}.}

\item{formula}{(formula) A symbolic description of the model to be fitted.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{HSDEM} object with the following \code{output} slots:
\tabular{ll}{
\code{p_value} \tab          (data.frame) The probability of observing the calculated statistic if the null hypothesis is true. \cr
\code{significant} \tab          (data.frame) True/False indicating whether the p-value computed for each variable is less than the threshold. \cr
}
}
\description{
Tukey's HSD post hoc test is a modified t-test applied for all features to all pairs of levels in a factor. It is used to determine which groups are different (if any). A multiple test corrected p-value is computed to indicate which groups are significantly different to the others for each feature. For mixed effects models estimated marginal means are used.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{emmeans}} \item{\code{nlme}}}
}
\section{Inheritance}{

A \code{HSDEM} object inherits the following \code{struct} classes: \cr\cr
\verb{[HSDEM]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = HSDEM(
      alpha = 0.05,
      mtc = "fdr",
      formula = y ~ x)

D = iris_DatasetExperiment()
D$sample_meta$id=rownames(D) # dummy id column
M = HSDEM(formula = y~Species+ Error(id/Species))
M = model_apply(M,D)

}
\references{
Lenth R (2024). \emph{emmeans: Estimated Marginal Means, aka Least-Squares
Means}. R package version 1.10.1,
\url{https://CRAN.R-project.org/package=emmeans}.

Pinheiro J, Bates D, R Core Team (2023). \emph{nlme: Linear and Nonlinear
Mixed Effects Models}. R package version 3.1-164,
\url{https://CRAN.R-project.org/package=nlme}.

Pinheiro JC, Bates DM (2000). \emph{Mixed-Effects Models in S and S-PLUS}.
Springer, New York. doi:10.1007/b98882
\url{https://doi.org/10.1007/b98882}.
}
