% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statAnalysis.R
\name{statAnalysis}
\alias{statAnalysis}
\title{statAnalysis for statistical analysis for omics data or others.}
\usage{
statAnalysis(
  file,
  Frule = 0.8,
  normM = "NONE",
  imputeM = "KNN",
  glog = TRUE,
  FDR = TRUE,
  ntree = 500,
  nvarRF = 5,
  scaling = "Pareto",
  plot.volcano = TRUE,
  save.boxplot = FALSE,
  silt = 20,
  pcax = 1,
  pcay = 2,
  Labels = TRUE,
  upper.lim = 2,
  lower.lim = 0.5,
  sig.lim = 0.05
)
}
\arguments{
\item{file}{The file with the expression information with long format}

\item{Frule}{Modified n precent rule function. A variable will be kept if it has a non-zero value
for at least n precent of samples in any one group. (Default: 0.8)}

\item{normM}{The parameter for normalization method (i.e median quotient 
normalization, 'PQN'; integral normalization , 'SUM', and 'NONE').}

\item{imputeM}{The parameter for imputation method i.e., nearest neighbor 
averaging, 'KNN'; minimum values, 'min'; Half of minimum values, 'minHalf'; 
median values, 'median'.}

\item{glog}{Generalised logarithm (glog) transformation, with the default 
value TRUE. The glog is a better behaved log transformation when some data 
values are zero or just near zero.}

\item{FDR}{The false discovery rate for conceptualizing the rate of type I 
errors in null hypothesis testing when conducting multiple comparisons.}

\item{ntree}{Number of trees to grow for randomForest model. This should not 
be set to too small a number, to ensure that every input row gets predicted 
at least a few times.}

\item{nvarRF}{The number of the variables with top importance in randomforest
model}

\item{scaling}{Scaling method before statistic analysis (PCA or PLS-DA). 
'pareto', 'Pareto', 'p' or 'P' can be used for specifying the Pareto scaling.
 'auto', 'Auto', 'auto', 'a' or 'A' can be used for specifying the Auto 
 scaling (or unit variance scaling). 'vast', 'Vast', 'v' or 'V' can be used
  for specifying the vast scaling. 'range', 'Range', 'r' or 'R' can be used 
  for specifying the Range scaling.}

\item{plot.volcano}{if TRUE, the volcano plot is performed}

\item{save.boxplot}{if TRUE, the box plot is performed}

\item{silt}{The number of permutation for PLS-DA model and variable importance of randomForest.}

\item{pcax}{Principal components in PCA model for the x-axis.}

\item{pcay}{Principal components in PCA model for the y-axis.}

\item{Labels}{Name labels for score plot of multiple statistical analysis}

\item{upper.lim}{The up-regulated metabolites using Fold Changes cut off 
values in the Volcano plot. Fold change values will be calculated 
before normalization step.}

\item{lower.lim}{The down-regulated metabolites using Fold Changes cut off
values in the Volcano plot. Fold change values will be calculated before 
normalization step.}

\item{sig.lim}{The significance level for metabolites in the Pvalues file in 
the Volcano plot.}
}
\value{
The statAnalsis output files. See the details at https://stattarget.github.io
}
\description{
statAnalysis provides the statistical analysis for metabolomics
 data or others.
}
\examples{
datpath <- system.file('extdata',package = 'statTarget')
file <- paste(datpath,'data_example_long.csv', sep='/')
statAnalysis(file,Frule = 0.8, normM = 'NONE', imputeM = 'KNN', glog = TRUE,scaling = 'Pareto')
}
\author{
Hemi Luan, hemi.luan@gmail.com
}
\keyword{P-value}
\keyword{PCA}
\keyword{PLSDA}
