% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiftCor_v2.R
\name{shiftCor}
\alias{shiftCor}
\title{shiftCor}
\usage{
shiftCor(
  samPeno,
  samFile,
  Frule = 0.8,
  MLmethod = "QCRFSC",
  ntree = 500,
  imputeM = "KNN",
  coCV = 30,
  plot = FALSE
)
}
\arguments{
\item{samPeno}{File path. The file with the meta information including the sample name,
batches, class and order.}

\item{samFile}{File path. The file with the expression information.}

\item{Frule}{Modified n precent rule function. A variable will be kept if it has a non-zero value
for at least n precent of samples in any one group. 
(Default: 0.8)}

\item{MLmethod}{The machine learning method for QC based signal correction, such as QC based random forest signal correction (QC-RFSC). QC-RLSC was deprecated .}

\item{ntree}{Number of trees to grow in random forest model.}

\item{imputeM}{The parameter for imputation method i.e., nearest neighbor 
averaging, 'KNN'; minimum values, 'min'; Half of minimum values, 'minHalf'; 
median values, 'median'.}

\item{coCV}{Define the cutoff value (0-100) of CV for controlling the number of features.}

\item{plot}{Defines if images of feature quality should be generated (TRUE) or not (FALSE). 
Defaults to FALSE.}
}
\value{
the shiftCor files. See the details at https://stattarget.github.io
}
\description{
shiftCor provides the QC based signal correction for 
large scale metabolomics and targeted proteomics.
}
\examples{
datpath <- system.file('extdata',package = 'statTarget')
samPeno <- paste(datpath,'MTBLS79_sampleList.csv', sep='/')
samFile <- paste(datpath,'MTBLS79.csv', sep='/')
samPeno
samFile
shiftCor(samPeno,samFile, MLmethod = 'QCRFSC', imputeM = 'KNN',coCV = 30)
}
\keyword{Controls,Correction}
\keyword{Quality}
