% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/accessors.R
\docType{methods}
\name{getTx2gene}
\alias{getTx2gene}
\alias{getTx2gene}
\alias{getTx2gene,stageRTx}
\title{Retrieve the data frame linking genes to transcripts.}
\usage{
getTx2gene(object, ...)

\S4method{getTx2gene}{stageRTx}(object, ...)
}
\arguments{
\item{object}{an object of the \code{stageRTxClass} class.}

\item{...}{Additional arguments}
}
\value{
A matrix linking gene to transcript identifiers.
}
\description{
This functions returns a data frame that links the genes with the transcripts being analysed.
}
\examples{
#make identifiers linking transcripts to genes
set.seed(1)
genes=paste0("gene",sample(1:200,1000,replace=TRUE))
nGenes=length(table(genes))
transcripts=paste0("tx",1:1000)
tx2gene=data.frame(transcripts,genes)
#gene-wise q-values
pScreen=c(seq(1e-10,1e-2,length.out=nGenes-100),seq(1e-2,.2,length.out=50),seq(50))
names(pScreen)=names(table(genes)) #discards genes that are not simulated
pConfirmation=matrix(runif(1000),nrow=1000,ncol=1)
rownames(pConfirmation)=transcripts
stageRObj <- stageRTx(pScreen=pScreen, pConfirmation=pConfirmation ,pScreenAdjusted=TRUE, tx2gene=tx2gene)
getTx2gene(stageRObj)
}
\references{
Van den Berge K., Soneson C., Robinson M.D., Clement L. (2017). stageR: a general stage-wise method for controlling the gene-level false discovery rate in differential expression and differential transcript usage. Genome Biology 18:151. https://doi.org/10.1186/s13059-017-1277-0
}
