% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolution.R
\name{resolutionCalc}
\alias{resolutionCalc}
\title{Resolution calculation}
\usage{
resolutionCalc(sampleInfo)
}
\arguments{
\item{sampleInfo}{A data.frame contains the pixel information and cluster labels for each barcode of a human breast cancer sample.
The index contains barcodes, and at least three other columns that have these information are required and the column names should be the same as following:
"imagerow": The row pixel coordinate of the center of the spot
"imagecol": The column pixel coordinate of the center of the spot
"Cluster": The label that corresponding to this barcode}
}
\value{
A list that contains length and height of resolution.
}
\description{
Automatic calculation of optimal raster resolution for the sample.
}
\examples{
fpath <- system.file("extdata", "dataframe.rda", package="stJoincount")
load(fpath)
resolutionList <- resolutionCalc(humanBC)
}
