% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joincount.R
\name{joincountAnalysis}
\alias{joincountAnalysis}
\title{Join count analysis}
\usage{
joincountAnalysis(mosaicIntegration)
}
\arguments{
\item{mosaicIntegration}{A raster object converted from a labeled spatial tissue map from Function rasterization.}
}
\value{
A data.frame that contains the observed join counts, the expected count under conditions of spatial randomness, the variance calculated under non-free sampling, and calculated Z-score.
}
\description{
This function performes multi-categorical join count analysis of
the rasterized sample. A neighbors list is then created from the rasterized sample,
in which adjacent and diagonal neighbors for each pixel are identified.
}
\examples{
fpath <- system.file("extdata", "dataframe.rda", package="stJoincount")
load(fpath)
mosaicIntegration <- rasterizeEachCluster(humanBC)
joincount.result <- joincountAnalysis(mosaicIntegration)
}
