#' DocSet instance with metadata from 68 cancer studies
#' @docType data
#' @format S4 class DocSet defined in ssrch
"docset_cancer68"
#' titles for 68 cancer studies
#' @docType data
#' @format character vector
"titles68"
#' pubmed URLs for subset of 68 cancer studies
#' @docType data
#' @format character vector
"urls68"
#' publication dates for 6000 SRA transcriptome studies
#' @docType data
#' @format data.frame
"study_publ_dates"
#' DocSet instance with metadata from 1009 cancer studies
#' @format S4 class DocSet defined in ssrch
#' @note This is part of a sequence of datasets assessing how
#' far we can go with environments of keywords.  Annotation for
#' 43000 samples is indexed here.
#' @return DocSet instance
#' @examples
#' ds_can1009b()
#' @export
ds_can1009b = function() {
 get(load(system.file("rda/ds_can1009b.rda", package="ssrch")))
}

