\name{akashi_test}
\alias{akashi_test}
\title{
  akashi test for codon usage
}
\description{
  The function calculate Akashi's test for translational accuracy selection on coding sequences. Akashi proposed the translational accurary theory for 
  codon usage in 1994. The theory suggest that the optimal codons are codons that translated more accurately than the other codons, and these codons
  are favored in the important sites, such as the evolutionary conserved amino acid sites, whereas the less conserved amino acids sites are more tolerable to the
  non-optimal codons. For detailed information, see reference listed below.
}
\usage{
  akashi_test(contingency_file=NULL)
}
\arguments{
  \item{contingency_file}{
	a character vector for the filepath of the contingency file, which was generated by the perl script make_contingency_table.pl
	in the perl_script folder in the package
}
}
\details{
  The function calculate Akashi's test for translational accuracy selection on coding sequences. 

  The input of the function is a contingency file, you can find an example in the folder akashi_test in the sscu directory.
  You can either make the file by yourself, or by the perl script make_contingency_table.pl in the akashi_test folder.
  You can check the detailed usage of the perl script by reading the first few lines in the perl script.
  The perl script tabulates and calculate the a,b,c,d entries for the coding sequences, and output the four values for each amino acid for each gene, 
  example as the contingency_file_Gvag.
  The input of the perl script is a folder contains the codon alignments of the genes that you are interested to calculate.
  For detailed information of Akashi's test, you can either refer to the publication by Akashi, or to the website http://drummond.openwetware.org/Akashi's_Test.html

  The function reads and calculates the Z value, p value and odd ratio for the Akashi's test. In addition, it calculates the conserved, variable,
  optimal and nonoptimal sites for the coding sequences. 
}
\value{
  a list of numeric vector is returned
  \item{Z}{Z value for Akashi's test}
  \item{p}{p value for Akashi's test}
  \item{odd_ratio}{odd_ratio for Akashi's test}
  \item{conserved_optimal_sites}{total number of conserved optimal sites}
  \item{conserved_non_optimal_sites}{total number of conserved non-optimal sites}
  \item{variable_optimal_sites}{total number of variable optimal sites}
  \item{variable_non_optimal_sites}{total number of variable non-optimal sites}
  \item{con_var_ratio}{the ratio of conserved against variable sites}
}
\references{
  Akashi H. Synonymous codon usage in Drosophila melanogaster: natural selection and translational accuracy. Genetics 1994 Mar;136(3):927-35.
  http://drummond.openwetware.org/Akashi's_Test.html
}

\author{
Yu Sun
}
\examples{
# ----------------------------------------------- #
#     Gardnerella vaginalis example               #
# ----------------------------------------------- #

  # Here is an example to calculate the genomic gc3
  # input the one multifasta files to calculate genomic gc3 
   akashi_test(system.file("akashi_test/contingency_file_Gvag",package="sscu"))

}

