% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_bam_standards.R
\name{model_bam_standards}
\alias{model_bam_standards}
\title{Build a Bayesian additive model from spike-ins to correct bias in *-seq}
\usage{
model_bam_standards(x, conc = NULL, fm = NULL, ...)
}
\arguments{
\item{x}{data with assorted feature information (GCfrac, CpGs, etc)}

\item{conc}{concentration for each spike (must be provided!)}

\item{fm}{model formula (conc ~ read_count + fraglen + GCfrac + CpGs_3)}

\item{...}{other arguments to pass to \code{bamlss}}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{   the model fit for the data
}\if{html}{\out{</div>}}
}
\description{
Build a Bayesian additive model from spike-ins to correct bias in *-seq
}
\examples{

library(bamlss)
data(spike_cram_counts,package="spiky")
data(spike,package="spiky")
scc <- add_frag_info(spike_cram_counts, spike=spike)
scc$conc <- scc$conc * 0.9 # adjust for dilution
scc$CpGs_3 <- scc$CpGs ^ (1/3)
fit0 <- model_bam_standards(scc,
                            fm=conc ~ read_count + fraglen)
fit1 <- model_bam_standards(scc,
                            fm=conc ~ read_count + fraglen + GCfrac + CpGs_3)
DIC(fit0, fit1)

}
