% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateBetaParam.R
\name{estimateBetaParam}
\alias{estimateBetaParam}
\title{Estimate the parameters of a Beta distribution}
\usage{
estimateBetaParam(x)
}
\arguments{
\item{x}{a vector of proportions.}
}
\value{
a list object with the estimate of alpha in \code{a} and beta in
\code{b}.
}
\description{
This function estimates the two parameters of the Beta distribution, alpha
and beta, given a vector of proportions. It uses the method of moments to
do this.
}
\examples{
# Generate proportions from a beta distribution
props <- rbeta(1000, shape1=2, shape2=10)
estimateBetaParam(props)

}
\author{
Belinda Phipson
}
