% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sphm_methods.R
\docType{methods}
\name{SPHMMethods}
\alias{SPHMMethods}
\alias{svg}
\alias{svg<-}
\alias{bulk}
\alias{bulk<-}
\alias{cell}
\alias{cell<-}
\alias{match}
\alias{match<-}
\alias{output}
\alias{output<-}
\alias{name}
\alias{length}
\alias{svg,SPHM-method}
\alias{svg<-,SPHM-method}
\alias{bulk,SPHM-method}
\alias{bulk<-,SPHM-method}
\alias{cell,SPHM-method}
\alias{cell<-,SPHM-method}
\alias{match,SPHM-method}
\alias{match<-,SPHM-method}
\alias{output,SPHM-method}
\alias{output<-,SPHM-method}
\alias{[,SPHM,ANY,ANY,ANY-method}
\alias{[<-,SPHM,ANY,ANY,ANY-method}
\alias{length,SPHM-method}
\alias{name,SPHM-method}
\title{Methods for S4 class \code{SPHM}}
\usage{
\S4method{svg}{SPHM}(x)

\S4method{svg}{SPHM}(x) <- value

\S4method{bulk}{SPHM}(x)

\S4method{bulk}{SPHM}(x) <- value

\S4method{cell}{SPHM}(x)

\S4method{cell}{SPHM}(x) <- value

\S4method{match}{SPHM}(x)

\S4method{match}{SPHM}(x) <- value

\S4method{output}{SPHM}(x)

\S4method{output}{SPHM}(x) <- value

\S4method{[}{SPHM,ANY,ANY,ANY}(x, i)

\S4method{[}{SPHM,ANY,ANY,ANY}(x, i) <- value

\S4method{length}{SPHM}(x)

\S4method{name}{SPHM}(x)
}
\arguments{
\item{x}{An `SPHM` object.}

\item{value}{A value for replacement.}

\item{i}{An integer specifying a slot of an \code{SPHM} object.}
}
\value{
An object of \code{SVG}, \code{SummarizedExperiment}, \code{SingleCellExperiment}, \code{data.frame}, \code{numeric}, or \code{list}.
}
\description{
These are methods for getting or setting \linkS4class{SPHM} objects.
}
\section{Main methods}{

In the following code snippets, \code{x} is an \linkS4class{SPHM} object.
\describe{
\item{\code{x[i]}, svg(x), bulk(x), cell(x), match(x), output(x)}{
  Subsetting a slot of \code{x}.
}
\item{x[i] <- value, svg(x) <- value, bulk(x) <- value, cell(x) <- value, match(x) <- value}{
  Replacing a slot value in \code{x}.
}
\item{\code{name(x)}}{
  All slot names in \code{x}.
}
\item{\code{length(x)}}{
  Number of all slots in \code{x}.
}
}
}

\examples{

# Import an aSVG image.
svg.hum.pa <- system.file("extdata/shinyApp/data", 'homo_sapiens.brain.svg', 
package="spatialHeatmap")
svg.hum <- read_svg(svg.hum.pa)
# aSVG features.
feature.hum <- attribute(svg.hum)[[1]]
set.seed(20)
unique(feature.hum$feature)[1:10] 

# Testing vector.
my_vec <- setNames(sample(1:100, 4), c('substantia.nigra', 'putamen', 'prefrontal.cortex', 
'notMapped')); my_vec   
# An SPHM object for storing bulk data and aSVG.
dat.quick <- SPHM(svg=svg.hum, bulk=my_vec) 
# Getters and setters for SPHM objects.
svg(dat.quick); svg(dat.quick) <- svg.hum
dat.quick['bulk']; dat.quick['bulk'] <- my_vec
}
\seealso{
\code{\link{SPHM}}: creating \code{SPHM} objects.
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
