% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsngls.R
\name{plotsngls}
\alias{plotsngls}
\title{The plotsngls() function}
\usage{
plotsngls(
  fitgls,
  lineplot = FALSE,
  nrow,
  ncol,
  structplot = TRUE,
  ith_lambda = 1
)
}
\arguments{
\item{fitgls}{It is a returning object of the sparsnetgls() multivariate
generalized least squared regression function.}

\item{lineplot}{It is a logical indicator. When value=TRUE, it will provide
line plot.}

\item{nrow}{It is a graph parameter representing number of rows in 
the lineplot.}

\item{ncol}{It is a graph parameter representing number of columns in 
the lineplot.}

\item{structplot}{It is a logical indicator. When value=TRUE, it will 
provide the structure plot of the specified precision matrix from 
the series of the sparsenetgls results.}

\item{ith_lambda}{It is the number for the specified precision matrix
to be used in the structplot. It represents the ordering number in the
precision matrix series from sparsenetgls.}
}
\value{
Return a plot subject for sparsenetgls including the plot of
variance vs lambda and graph structure of the precision matrix estimates.
}
\description{
The plotsngls function is designed to provide the line plots
of variance of regression coefficients vs. values of penalized parameter 
lambda in gls regression, when the tuning parameter d is the maximal value. It
also provides the graph structure of the estimated precision matrix in the 
penalized path.
}
\examples{
ndox=5;p=3;n=200
VARknown <- rWishart(1, df=4, Sigma=matrix(c(1,0,0,0,1,0,0,0,1),
nrow=3,ncol=3))
normc <- mvrnorm(n=n,mu=rep(0,p),Sigma=VARknown[,,1])
Y0=normc
##u-beta
u <- rep(1,ndox)
X <- mvrnorm(n=n,mu=rep(0,ndox),Sigma=Diagonal(ndox,rep(1,ndox)))        
X00 <- scale(X,center=TRUE,scale=TRUE)
X0 <- cbind(rep(1,n),X00)
#Add predictors of simulated CNA
abundance1 <- scale(Y0,center=TRUE,scale=TRUE)+as.vector(X00\%*\%as.matrix(u))

##sparsenetgls()
fitgls <- sparsenetgls(responsedata=abundance1,predictdata=X00,
nlambda=5,ndist=4,method='lasso')
plotsngls(fitgls, ith_lambda=5)
#plotsngls(fitgls,lineplot=TRUE,structplot=FALSE,nrow=2,ncol=3)
}
