% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lassoglmnet.R
\name{lassoglmnet}
\alias{lassoglmnet}
\title{The lassoglmnet() function}
\usage{
lassoglmnet(Y0, nlambda = 10, alpha)
}
\arguments{
\item{Y0}{The data matrix for the GGM model.}

\item{nlambda}{The number of interval used in the penalized path in lasso
and elastics. It results in the number of lambda values to be used in the
penalization. The default value is 10.}

\item{alpha}{The value to be used in enet, it has values between 0 and 1.
The value of 0 is corresponding to l-1 penalization,
and 1 is corresponding to the l-2 regularization (Ridge regression).
The other values between 0 and 1 will result in a
combination of l1-l2 norm regularization named as elastic net.}
}
\value{
Return the regression coefficients of glmnet 'coef_glmnet',
residuals from the glmnet 'resid_glmnet' and lambda.
}
\description{
The lassoglmnet function is designed to learn the graph 
structure by using the lasso and elastics net methods.
}
\examples{
n=20
VARknown <- rWishart(1,df=4,Sigma=matrix(c(1,0,0,0,1,0,0,0,1),nrow=3,ncol=3))
Y0 <- mvrnorm(n=n,mu=rep(0.5,3),Sigma=VARknown[,,1])
fitlasso <- lassoglmnet(Y0=Y0,alpha=0.5)

}
