% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/GeneSetDb-methods.R
\name{subsetByFeatures}
\alias{subsetByFeatures}
\alias{subsetByFeatures,GeneSetDb-method}
\title{Subset a GeneSetDb to only include geneSets with specified features.}
\usage{
subsetByFeatures(x, features, value = c("feature_id", "x.id", "x.idx"), ...)

\S4method{subsetByFeatures}{GeneSetDb}(x, features, value = c("feature_id", "x.id", "x.idx"), ...)
}
\arguments{
\item{x}{\code{GeneSetDb}}

\item{features}{Character vector of featureIds}

\item{value}{are you feature id's entered as themselves (\code{feature_id}), which
is the default, or are you querying by their index into a target expression
object? This is only relevant if you are working with a \code{conform}-ed
GeneSetDb, and further you as a user won't likely invoke this argument,
but is used internally.}

\item{...}{pass through arguments}
}
\value{
A subset of \code{x} which contains only the geneSets that contain
features found in \code{featureIds}
}
\description{
Subset a GeneSetDb to only include geneSets with specified features.
}
\section{Methods (by class)}{
\itemize{
\item \code{subsetByFeatures(GeneSetDb)}: subset GeneSetDb by feature id's

}}
\examples{
gdb <- exampleGeneSetDb()
features <- c("55839", "8522", "29087")
(gdb.sub <- subsetByFeatures(gdb, features))
}
