% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneSetDb-methods.R
\name{incidenceMatrix}
\alias{incidenceMatrix}
\title{Creates a 1/0 matrix to indicate geneset membership to target object.}
\usage{
incidenceMatrix(x, y, ...)
}
\arguments{
\item{x}{A \code{\link[=GeneSetDb]{GeneSetDb()}}}

\item{y}{(optional) A target (expression) object \code{x} is (or can be)
conformed to}

\item{...}{parameters passed down into \code{\link[=conform]{conform()}}.}
}
\value{
incidence matrix with nrows = number of genesets and columns are
featureIDs. If \code{y} is passed in, the columns of the returned value
match the rows of \code{y}.
}
\description{
Generates an inidcator matrix to indicate membership of genes (columns)
to gene sets (rows). If \code{y} is provided, then the incidence is mapped
across the entire feature-space of \code{y}.
}
\examples{
vm <- exampleExpressionSet()
gdb <- exampleGeneSetDb()
im <- incidenceMatrix(gdb)
imv <- incidenceMatrix(gdb, vm)
}
