% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/GeneSetDb-methods.R,
%   R/SparrowResult-methods.R
\name{featureIds}
\alias{featureIds}
\alias{featureIds,GeneSetDb-method}
\alias{featureIds,SparrowResult-method}
\title{Returns the relevant featureIds for a given geneset.}
\usage{
featureIds(
  x,
  i,
  j,
  value = c("feature_id", "x.id", "x.idx"),
  active.only = is.conformed(x),
  ...
)

\S4method{featureIds}{GeneSetDb}(
  x,
  i,
  j,
  value = c("feature_id", "x.id", "x.idx"),
  active.only = is.conformed(x),
  ...
)

\S4method{featureIds}{SparrowResult}(
  x,
  i,
  j,
  value = c("feature_id", "x.id", "x.idx"),
  active.only = TRUE,
  ...
)
}
\arguments{
\item{x}{Object to retrieve the gene set from, either a \code{GeneSetDb} or a
\code{SparrowResult}.}

\item{i, j}{The collection,name compound key identifier of the gene set}

\item{value}{What form do you want the id's in?
\itemize{
\item \code{"feature_id"}: the IDs used in the original geneset definitions
\item \code{"x.id"}: the ids of the features as they are used in the expression
object.
\item \code{"x.idx"}: The integer index into the expresion object \code{x} that the
`GeneSetDb`` has been conformed to.
}}

\item{active.only}{only look for gene sets that are "active"? Defaults to
\code{TRUE} if \code{x} is conformed to a target expression object, else \code{FALSE}.
\code{\link[=conform]{conform()}} for further details.}

\item{...}{pass through arguments}
}
\value{
A vector of identifiers (or indexes into an expression object,
depending on the \code{value} argument) for the features in the specified
geneset. \code{NA} is returned if the geneset is not "active" (ie. listed in
\code{\link[=geneSets]{geneSets()}})
}
\description{
Gene sets are defined by the unique compound key consisting of their
\code{collection} and \code{name}. To fetch the featureIds associated with
a specific geneset, you must provide values for \code{i} and \code{j}. If
these are missing, then a character vector of all the unique feature ids
within \code{x} are returned.

If the GeneSetDb \code{x} has been conformed to an expression object this
will default to return only the feature_id's that are matched to the target
expression object, and they will be returned using the same identifiers that
the target expression object uses. To change this behavior, tweak the values
for the \code{active.only} and \code{value} parameters, respectively.

\code{x} can be either a \code{GeneSetDb} or a \code{SparrowResult}. If its the latter,
then this call simply delegates to the internal \code{GeneSetDb}.
}
\examples{
gdb <- exampleGeneSetDb()
fids.gs <- featureIds(gdb, 'c2', 'BIOCARTA_AGPCR_PATHWAY')
fids.c2 <- featureIds(gdb, 'c2')
fids.all <- featureIds(gdb)

vm <- exampleExpressionSet(do.voom=TRUE)
gdb <- conform(gdb, vm)
## fewer than before
fids.gs2 <- featureIds(gdb, 'c2', 'BIOCARTA_AGPCR_PATHWAY')
## same as before
fids.gs3 <- featureIds(gdb, 'c2', 'BIOCARTA_AGPCR_PATHWAY', active.only=FALSE)
## returned as row indices into vm
fids.idxs <- featureIds(gdb, 'c2', value='x.idx')
}
