% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{failWith}
\alias{failWith}
\title{Utility function to try and fail with grace.}
\usage{
failWith(
  default = NULL,
  expr,
  frame = parent.frame(),
  message = geterrmessage(),
  silent = FALSE,
  file = stderr()
)
}
\arguments{
\item{default}{the value to return if \code{expr} fails}

\item{expr}{the expression to take a shot at}

\item{frame}{the frame to evaluate the expression in}

\item{message}{the error message to display if \code{expr} fails. Deafults
to \code{\link[base:stop]{base::geterrmessage()}}}

\item{silent}{if \code{TRUE}, sends the error message to \code{\link[=msg]{msg()}}}

\item{file}{where msg sends the message}
}
\value{
the result of \code{expr} if successful, otherwise \code{default} value.
}
\description{
Inspired from one of Hadley's functions (in plyr or something?)
}
\examples{
# look, this doesn't throw an error, it just returns NULL
x <- failWith(NULL, stop("no error, just NULL"), silent = TRUE)
}
