% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_mixing.R
\name{simulate_mixing}
\alias{simulate_mixing}
\title{Simulate mixed background image}
\usage{
simulate_mixing(
  bg_sample = bg1,
  idents = c("Tumour", "Immune", "Others"),
  props = c(0.2, 0.4, 0.4),
  plot_image = TRUE,
  plot_colours = NULL
)
}
\arguments{
\item{bg_sample}{(OPTIONAL) A data frame or \code{SpatialExperiment} class object
with locations of points representing background cells. Further cell types
will be simulated based on this background sample. The data.frame or the
\code{spatialCoords()} of the SPE object should have colnames including
"Cell.X.Positions" and "Cell.Y.Positions". By default use the internal
\code{\link{bg1}} background image.}

\item{idents}{String Vector of the mixed cell types.}

\item{props}{Numeric Vector of the proportions of the mixed cell types.}

\item{plot_image}{Boolean. Whether the simulated image is plotted.}

\item{plot_colours}{String Vector specifying the order of the colours that
correspond to the \code{idents} arg. Default is NULL - the predefined
colour vector would be used for plotting..}
}
\value{
A data.frame of the simulated image
}
\description{
Based on an existing background image, simulate mixed cell types
with specified cell types and proportions. The default values for the
arguments give an example of mixed cell type simulation which enable an
automatic simulation of mixed cell types without the specification of any
argument.
}
\examples{
set.seed(610)
mix_background <- simulate_mixing(bg_sample=bg1,
idents=c("Tumour","Immune", "Others"), props=c(0.2, 0.4,  0.4),
plot_image=TRUE)
}
\seealso{
\code{\link{simulate_background_cells}} for all cell simulation,
\code{\link{simulate_clusters}} for cluster simulation,
\code{\link{simulate_immune_rings}}/\code{\link{simulate_double_rings}} for
immune ring simulation, and \code{\link{simulate_stripes}} for vessel
simulation.

Other simulate pattern functions: 
\code{\link{simulate_background_cells}()},
\code{\link{simulate_clusters}()},
\code{\link{simulate_double_rings}()},
\code{\link{simulate_immune_rings}()},
\code{\link{simulate_stripes}()}
}
\concept{simulate pattern functions}
