% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higher_level_functions.R
\name{junction_intersection}
\alias{junction_intersection}
\title{Get the intersection of junctions from 2 or more compilations
which are on the same reference}
\usage{
junction_intersection(...)
}
\arguments{
\item{...}{One or more QueryBuilder objects}
}
\value{
A RangedSummarizedExperiment of junctions common across compilations
}
\description{
This function operates similar to the \code{junction_union()} function, i.e
it is cross compilation and merging of the same junction from multiple
compilations will be handled exactly the same way. But instead
of every junction which appears in at least one compilation, only
the junctions which appear in \emph{every} compilation will be returned.
}
\examples{
# Using query builder wrappers
sb1 <- QueryBuilder(compilation = "gtex", regions = "chr1:1879786-1879786")
sb1 <- set_coordinate_modifier(sb1, Coordinates$EndIsExactOrWithin)
sb1 <- set_row_filters(sb1, strand == "-")

sb2 <- QueryBuilder(compilation = "tcga", regions = "chr1:1879786-1879786")
sb2 <- set_coordinate_modifier(sb2, Coordinates$EndIsExactOrWithin)
sb2 <- set_row_filters(sb2, strand == "-")

junction_intersection(sb1, sb2)
}
\seealso{
\code{\link[=junction_union]{junction_union()}}
}
