% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higher_level_functions.R
\name{junction_inclusion_ratio}
\alias{junction_inclusion_ratio}
\title{Relative measure of splice variant usage similar to PSI that allows
for 2 arbitrarily defined groups of junctions (not limited to
cassette exons).}
\usage{
junction_inclusion_ratio(group1, group2, group_names = NULL)
}
\arguments{
\item{group1, group2}{Each group is a list of 1 or more
QueryBuilder objects}

\item{group_names}{Optional vector of strings representing the
group names}
}
\value{
A DataFrame of samples, with their JIR score and metadata,
which had > 0 coverage in at least one resulting row in at
least one of the groups
}
\description{
Calculates a coverage summary statistic per sample of the normalized
coverage difference between two sets of separate junctions defined
by at least two basic queries and organized into two groups.
}
\details{
The summary statistic is as follows:
If the coverage of the first group is "A" and the second is "B":

\code{JIR(A,B)=(A - B) / (A+B+1)}

This is calculated for every sample that occurs in one or the other
(or both) groups results.
}
\examples{
sb1 <- QueryBuilder(compilation = "srav2", regions = "chr2:29446395-30142858")
sb1 <- set_coordinate_modifier(sb1, Coordinates$Within)
sb1 <- set_row_filters(sb1, strand == "-")

sb2 <- QueryBuilder(compilation = "srav2", regions = "chr2:29416789-29446394")
sb2 <- set_coordinate_modifier(sb2, Coordinates$Within)
sb2 <- set_row_filters(sb2, strand == "-")

junction_inclusion_ratio(list(sb1), list(sb2))
}
