% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/methods-buildHyperFrame.R
\name{buildHyperFrame}
\alias{buildHyperFrame}
\alias{buildHyperFrame,data.frame-method}
\alias{buildHyperFrame,matrix-method}
\alias{buildHyperFrame,list-method}
\alias{buildHyperFrame,SpatialExperiment-method}
\title{Build a hyperframe containing all point patterns of an experiment.}
\usage{
buildHyperFrame(x, ...)

\S4method{buildHyperFrame}{data.frame}(
  x,
  coordVars,
  imageIdentifier = imageVars,
  imageVars,
  pointVars = setdiff(names(x), c(imageVars, imageIdentifier, coordVars, featureName)),
  featureName = "gene",
  ...
)

\S4method{buildHyperFrame}{matrix}(
  x,
  imageVars,
  imageIdentifier = imageVars,
  covariates,
  featureName = "gene",
  ...
)

\S4method{buildHyperFrame}{list}(
  x,
  coordVars = c("x", "y"),
  covariates = NULL,
  idVar = NULL,
  featureName = "gene",
  ...
)

\S4method{buildHyperFrame}{SpatialExperiment}(x, imageVars, pointVars, imageIdentifier = imageVars, ...)
}
\arguments{
\item{x}{the input object, see methods('buildHyperFrame')}

\item{...}{additional constructor arguments}

\item{coordVars}{Names of coordinates}

\item{imageIdentifier}{A character vector of variables whose unique combinations
define the separate point patterns (images)}

\item{imageVars}{Covariates belonging to the point patterns}

\item{pointVars}{Names of event-wise covariates such as gene or cell for each single point}

\item{featureName}{The name of the feature identifier for the molecules.}

\item{covariates}{A matrix or dataframe of covariates}

\item{idVar}{An optional id variable present in covariates, that is matched
with the names of covariates}

\item{list}{A list of matrices or of point patterns of class 'spatstat.geom::ppp'}
}
\value{
An object of class 'hyperframe' from the 'spatstat.geom' package
}
\description{
Build a spatstat hyperframe with point patterns and metadata.
Matrices, dataframe, lists and SpatialExperiment inputs are accepted.
}
\examples{
data(Yang)
hypYang <- buildHyperFrame(Yang,
    coordVars = c("x", "y"),
    imageVars = c("day", "root", "section")
)
}
\seealso{
\link[spatstat.geom]{hyperframe}
}
