% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top_markers.R
\name{top_markers_init}
\alias{top_markers_init}
\title{compute group summarized score and order genes based on processed scores}
\usage{
top_markers_init(
  data,
  label,
  n = 10,
  use.glm = TRUE,
  batch = NULL,
  scale = TRUE,
  use.mgm = TRUE,
  softmax = TRUE,
  ...
)
}
\arguments{
\item{data}{matrix, features in row and samples in column}

\item{label}{a vector of group label}

\item{n}{integer, number of returned top genes for each group}

\item{use.glm}{logical, if to use \code{\link[stats:glm]{stats::glm()}} to compute group mean score,
if TRUE, also compute mean score difference as output}

\item{batch}{a vector of batch labels, default NULL}

\item{scale}{logical, if to scale data by row}

\item{use.mgm}{logical, if to scale data using \code{\link[=scale_mgm]{scale_mgm()}}}

\item{softmax}{logical, if to apply softmax transformation on output}

\item{...}{params for \code{\link[=top_markers_abs]{top_markers_abs()}} or \code{\link[=top_markers_glm]{top_markers_glm()}}}
}
\value{
a tibble with feature names, group labels and ordered processed scores
}
\description{
compute group summarized score and order genes based on processed scores
}
\examples{
data <- matrix(rgamma(100, 2), 10, dimnames = list(1:10))
top_markers_init(data, label = rep(c("A", "B"), 5))
}
