% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_idf_iae_wrappers.R
\name{tf}
\alias{tf}
\title{compute term/feature frequency within each cell}
\usage{
tf(expr, log = FALSE)
}
\arguments{
\item{expr}{a count matrix, features in row and cells in column}

\item{log}{logical, if to do log-transformation}
}
\value{
a matrix of term/gene frequency
}
\description{
compute term/feature frequency within each cell
}
\details{
\deqn{\mathbf{TF_{i,j}}=\frac{N_{i,j}}{\sum_j{N_{i,j}}}}
where \eqn{N_{i,j}} is the counts of feature i in cell j.
}
\examples{
data <- matrix(rpois(100, 2), 10, dimnames = list(1:10))
smartid:::tf(data)
}
