% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_idf_iae_wrappers.R
\name{iae_m}
\alias{iae_m}
\title{inverse average expression: max}
\usage{
iae_m(expr, features = NULL, thres = 0)
}
\arguments{
\item{expr}{a matrix, features in row and cells in column}

\item{features}{vector, feature names or indexes to compute}

\item{thres}{numeric, cell only counts when expr > threshold, default 0}
}
\value{
a matrix of inverse average expression score for each feature
}
\description{
inverse average expression: max
}
\details{
\deqn{\mathbf{IAE_{i,j}} = log(1+\frac{max_{\{i^{'}\in j\}}(n_{i^{'}})}{\sum_{j = 1}^{n} max(0, N_{i,j} - threshold)+1})}
where \eqn{i} is the feature \eqn{i} and \eqn{i^{'}} is the feature except
\eqn{i}, \eqn{N_{i,j}} is the counts of feature \eqn{i} in cell \eqn{j}, and
\eqn{n_{i^{'}}} is \eqn{\sum_{j = 1}^{n} sign(N_{i,j} > threshold)}.
}
\examples{
data <- matrix(rpois(100, 2), 10, dimnames = list(1:10))
smartid:::iae_m(data)
}
