% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllHelperFunctions.R
\name{slingClusterLabels}
\alias{slingClusterLabels}
\alias{slingClusterLabels,PseudotimeOrdering-method}
\alias{slingClusterLabels,SlingshotDataSet-method}
\alias{slingClusterLabels,SingleCellExperiment-method}
\title{Extract cluster labels used by Slingshot}
\usage{
slingClusterLabels(x)

\S4method{slingClusterLabels}{PseudotimeOrdering}(x)

\S4method{slingClusterLabels}{SlingshotDataSet}(x)

\S4method{slingClusterLabels}{SingleCellExperiment}(x)
}
\arguments{
\item{x}{an object containing \code{\link{slingshot}} output.}
}
\value{
Typically returns a matrix of cluster assignment weights
  (\code{#cells} by \code{#clusters}). Rarely, a vector of cluster labels.
}
\description{
Extract the cluster labels used by \code{\link{slingshot}}.
}
\examples{
data("slingshotExample")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
pto <- slingshot(rd, cl, start.clus = '1')
slingClusterLabels(pto)
}
