% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/conversion.R
\name{as.PseudotimeOrdering}
\alias{as.PseudotimeOrdering}
\alias{as.PseudotimeOrdering,SlingshotDataSet-method}
\alias{as.PseudotimeOrdering,SingleCellExperiment-method}
\alias{as.PseudotimeOrdering,PseudotimeOrdering-method}
\title{Conversion to PseudotimeOrdering}
\usage{
as.PseudotimeOrdering(x, ...)

\S4method{as.PseudotimeOrdering}{SlingshotDataSet}(x)

\S4method{as.PseudotimeOrdering}{SingleCellExperiment}(x)

\S4method{as.PseudotimeOrdering}{PseudotimeOrdering}(x)
}
\arguments{
\item{x}{an object containing \code{slingshot} output.}

\item{...}{additional arguments to pass to object-specific methods.}
}
\value{
A \code{PseudotimeOrdering} object containing the \code{slingshot}
  results from the original object, \code{x}.
}
\description{
This function converts objects that contain \code{slingshot}
  results into a \code{\link[TrajectoryUtils]{PseudotimeOrdering}}.
}
\examples{
data("slingshotExample")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
library(SingleCellExperiment)
u <- matrix(rpois(140*50, 5), nrow = 50)
sce <- SingleCellExperiment(assays = list(counts = u), 
                            reducedDims = SimpleList(PCA = rd),
                            colData = data.frame(clus = cl))
sce <- slingshot(sce, clusterLabels = 'clus', reducedDim = 'PCA')
as.PseudotimeOrdering(sce)

}
