% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPathway.R
\name{getPathwayResultNames}
\alias{getPathwayResultNames}
\title{List pathway analysis result names}
\usage{
getPathwayResultNames(inSCE, stopIfNone = FALSE, verbose = FALSE)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{stopIfNone}{Whether to stop and raise an error if no results found. If
\code{FALSE}, will return an empty character vector.}

\item{verbose}{Show warning if no result found. Default \code{FALSE}}
}
\value{
A character vector of valid pathway analysis result names.
}
\description{
List pathway analysis result names
}
\details{
Pathway analysis results will be stored as matrices in
\code{reducedDims} slot of \code{inSCE}. This function lists the result names
stored in \code{metadata} slot when analysis is performed.
}
\examples{
data(scExample)
getPathwayResultNames(sce)
}
