% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seuratFunctions.R
\name{runSeuratJackStraw}
\alias{runSeuratJackStraw}
\title{runSeuratJackStraw
Compute jackstraw plot and store the computations in the input sce object}
\usage{
runSeuratJackStraw(
  inSCE,
  useAssay,
  dims = NULL,
  numReplicate = 100,
  propFreq = 0.025,
  externalReduction = NULL
)
}
\arguments{
\item{inSCE}{(sce) object on which to compute and store jackstraw plot}

\item{useAssay}{Specify name of the assay to use for scaling. Assay name
provided against this parameter is scaled by the function and used
for the computation of JackStraw scores along with the reduced dimensions
specified by the \code{dims} parameter.}

\item{dims}{Number of components to test in Jackstraw. If \code{NULL}, then
all components are used. Default \code{NULL}.}

\item{numReplicate}{Numeric value indicating the number of replicate
samplings to perform.
 Default value is \code{100}.}

\item{propFreq}{Numeric value indicating the proportion of data to randomly
permute for each replicate.
 Default value is \code{0.025}.}

\item{externalReduction}{Pass DimReduc object if PCA/ICA computed through
other libraries. Default \code{NULL}.}
}
\value{
Updated \code{SingleCellExperiment} object with jackstraw
computations stored in it
}
\description{
runSeuratJackStraw
Compute jackstraw plot and store the computations in the input sce object
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runSeuratNormalizeData(sce, useAssay = "counts")
sce <- runSeuratFindHVG(sce, useAssay = "counts")
sce <- runSeuratScaleData(sce, useAssay = "counts")
sce <- runSeuratPCA(sce, useAssay = "counts")
sce <- runSeuratJackStraw(sce, useAssay = "counts")
}
}
