% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbb-step1-fit.R
\name{permut_asmbplsda}
\alias{permut_asmbplsda}
\title{Permutation test for asmbPLSDA global significance for LOO}
\usage{
permut_asmbplsda(
  object,
  npermut = 100,
  nbObsPermut = NULL,
  Nc = 1,
  CV_error,
  measure = "B_accuracy",
  Method = NULL,
  maxiter = 100
)
}
\arguments{
\item{object}{A superpathway fit model list.}

\item{npermut}{Number of permutations (default: 100).}

\item{nbObsPermut}{Number of samples to permute per iteration
(default: NULL).}

\item{Nc}{Number of samples dropped per permutation (default: 1).}

\item{CV_error}{Cross-validation error of the fitted model.}

\item{measure}{Accuracy measure (\code{"F1"}, \code{"accuracy"}, \code{"B_accuracy"},
\code{"precision"}, \code{"recall"}, default: \code{"B_accuracy"}).}

\item{Method}{Decision rule for prediction (default: NULL).}

\item{maxiter}{Maximum iterations (default: 100).}
}
\value{
A list with permutation statistics, p-value, and confidence
intervals.
}
\description{
Performs permutation testing for asmbPLS-DA to evaluate model validity.
}
\examples{
file <- system.file("extdata", "example_superpathway_fit_model.rda",
package = "singIST")
load(file)
data <- example_superpathway_fit_model
permut_asmbplsda(data, npermut = 5, Nc = 1,
CV_error = 1)
}
