% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-all-input.R
\name{create_pathway}
\alias{create_pathway}
\title{Create pathway object}
\usage{
create_pathway(standard_name, dbsource, collection, subcollection)
}
\arguments{
\item{standard_name}{Character. Pathway standard name from MsigDB.}

\item{dbsource}{Character. Database source (KEGG, PID, REACTOME, BIOCARTA, WIKIPATHWAYS).}

\item{collection}{Character. MsigDB collection (c2 or m2).}

\item{subcollection}{Character. MsigDB subcollection (CP).}
}
\value{
A list with elements: standard_name, dbsource, collection, subcollection.
}
\description{
Creates a simple list representing a pathway, after validating its fields.
}
\examples{
my_pathway <- create_pathway(
  standard_name = "KEGG_CYTOKINE_CYTOKINE_RECEPTOR_INTERACTION",
  dbsource = "KEGG",
  collection = "c2",
  subcollection = "CP"
)
print(my_pathway)
}
