% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-all-input.R
\name{create_mapping_organism}
\alias{create_mapping_organism}
\title{Create mapping organism object}
\usage{
create_mapping_organism(
  organism,
  target_class,
  base_class,
  celltype_mapping,
  counts
)
}
\arguments{
\item{organism}{Character(1). Scientific Latin name of the organism.}

\item{target_class}{Character(1). Name of the target class for this organism.}

\item{base_class}{Character(1). Name of the base class for this organism.}

\item{celltype_mapping}{List. Mapping of cell types to clusters (character vectors).}

\item{counts}{\code{Seurat} or \code{SingleCellExperiment} object with the scRNA-seq
LogNormalized counts. This object should contain variables in
\code{slot(SeuratObject, meta.data)} slot or
\code{slot(SingleCellExperimentObject, metadata)}; \code{class} indicating the class
the sample belongs to; \code{celltype_cluster} indicating the cell type cluster
(either character or numeric); \code{donor} indicating the sample ID.}
}
\value{
A list of class \code{"mapping.organism"} with elements:
\itemize{
\item organism
\item target_class
\item base_class
\item celltype_mapping
\item counts
}
}
\description{
Creates a simple S3 object (list with class "mapping.organism") after validating its components.
}
\examples{
counts <- SeuratObject::pbmc_small
colnames(slot(counts, "meta.data"))[1] <- "donor"
colnames(slot(counts, "meta.data"))[6] <- "class"
colnames(slot(counts, "meta.data"))[7] <- "celltype_cluster"
celltype_mapping <- list("T-cell" = c("T"), "Dendritic Cell" = character(0))
obj <- create_mapping_organism("Mus musculus", "g1", "g2", celltype_mapping,
counts)
}
