% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step2-biologicalLink.R
\name{celltype_mapping}
\alias{celltype_mapping}
\title{Cell type mapping}
\usage{
celltype_mapping(object)
}
\arguments{
\item{object}{A mapping organism list}
}
\value{
A mapping organism list with the \code{object$counts}
slot updated, for the variable \code{celltype_cluster} with the cell types
according to the mapping defined in \code{object$celltype_mapping}.
}
\description{
For a given mapping organism list it updates the variable
\code{celltype_cluster} so that each element of it is updated accordingly
to the mapped cell types as indicated in \code{object$celltype_mapping}.
}
\examples{
file <- system.file("extdata", "example_mapping_organism.rda",
package = "singIST")
load(file)
data <- example_mapping_organism
new_object <- celltype_mapping(data)
new_object$counts$celltype_cluster
}
