% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbb-step1-fit.R
\name{asmbPLSDA.cv.kcv}
\alias{asmbPLSDA.cv.kcv}
\title{K‐fold × Repeated Cross‐Validation for asmbPLS-DA}
\usage{
asmbPLSDA.cv.kcv(
  X.matrix,
  Y.matrix,
  PLS_term = 2,
  X.dim,
  quantile.comb.table,
  k = 4,
  ncv = 10,
  outcome.type = c("binary", "multiclass"),
  Method = NULL,
  measure = "B_accuracy",
  parallel = FALSE,
  expected.measure.increase = 0.005,
  center = TRUE,
  scale = TRUE,
  maxiter = 100
)
}
\arguments{
\item{X.matrix}{Predictor matrix (n×p)}

\item{Y.matrix}{Response one‐hot matrix (n×q)}

\item{PLS_term}{Integer: maximum number of PLS components}

\item{X.dim}{Vector: feature counts per block}

\item{quantile.comb.table}{Matrix (C×length(X.dim)): quantile combinations}

\item{k}{Integer: number of CV k (K)}

\item{ncv}{Integer: number of ncv}

\item{outcome.type}{"binary" or "multiclass"}

\item{Method}{Prediction method}

\item{measure}{"B_accuracy","accuracy","precision","recall","F1"}

\item{parallel}{Logical: TRUE to parallelize per-fold}

\item{expected.measure.increase}{Numeric: min performance gain to add PLS}

\item{center}{Logical: center predictors}

\item{scale}{Logical: scale predictors}

\item{maxiter}{Integer: max iterations for asmbPLSDA.fit}
}
\value{
A list with:
\item{quantile_table_CV}{Matrix (PLS_term × (blocks + metrics)) of optimal
quantiles and CV metrics}
\item{optimal_nPLS}{Integer: selected number of PLS components}
\item{splits}{List of length (k*ncv) of train/validation splits}
}
\description{
Implements stratified K‐fold cross‐validation with repetitions, mirroring the
structure of \code{asmbPLSDA.cv.loo} but using K k and ncv instead of LOO.
}
\examples{
# example code
file <- system.file("extdata", "example_superpathway_input.rda",
package = "singIST")
load(file)
data <- example_superpathway_input
matrices <- matrixToBlock(data)
X.matrix <- matrices$block_predictor
Y.matrix <- matrices$matrix_response
X.dim <- matrices$block_dim
quantile.comb.table <- data$hyperparameters_info$quantile_comb_table
quantile.comb.table <- rbind(quantile.comb.table, c(0.1, 0.2)) # Add 2 cases
outcome.type <- data$hyperparameters_info$outcome_type
asmbPLSDA.cv.kcv(X.matrix, Y.matrix, PLS_term = 1,
X.dim,quantile.comb.table,Method = NULL, measure = "B_accuracy",
parallel = TRUE, outcome.type = outcome.type,
expected.measure.increase = 0.005, center = TRUE, scale = TRUE,
maxiter = 100)
}
