% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich.R
\name{dag_enrich_on_offsprings_by_permutation}
\alias{dag_enrich_on_offsprings_by_permutation}
\title{Enrichment analysis on offspring terms by permutation test}
\usage{
dag_enrich_on_offsprings_by_permutation(
  dag,
  value,
  perm = 1000,
  min_offspring = 10,
  verbose = simona_opt$verbose
)
}
\arguments{
\item{dag}{An \code{ontology_DAG} object.}

\item{value}{A numeric value. The value should correspond to terms in \code{dag@terms}.}

\item{perm}{Number of permutations.}

\item{min_offspring}{Minimal size of the offspring set.}

\item{verbose}{Whether to print messages.}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{term}: Term names.
\item \code{stats}: The statistics of terms.
\item \code{n_offspring}: Number of offspring terms of \code{t} (including \code{t} itself).
\item \code{log2_fold_enrichment}: defined as \code{log2(s/mean)} where \code{mean} is calculated from random permutation.
\item \code{z_score}: Defined as \code{(s - mean)/sd} where \code{mean} and \code{sd} are calculated from random permutation.
\item \code{p_value}: P-values from permutation test.
\item \code{p_adjust}: Adjusted p-values from the BH method.
}

The number of rows in the data frame is the same as the number of terms in the DAG.
}
\description{
Enrichment analysis on offspring terms by permutation test
}
\details{
In the function \code{\link[=dag_enrich_on_offsprings]{dag_enrich_on_offsprings()}}, the statistic for testing is the number of terms in each category. Here
this funtion makes the testing procedure more general

The function tests whether a term \code{t}'s offspring terms have an over-represented pattern on values in \code{value}.
Denote \code{T} as the set of \code{t}'s offspring terms plus \code{t} itself, and \code{v} as the numeric vector of \code{value}, we first
calculate a score \code{s} based on values in \code{T}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{s = mean_\{terms in T\}(v)
}\if{html}{\out{</div>}}

To construct a random version of \code{s}, we randomly sample \code{n_T} terms from the DAG where \code{n_T} is the size of set \code{T}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{sr_i = mean_\{n_T randomly sampled terms\}(v)
}\if{html}{\out{</div>}}

where index \code{i} represents the i^th sampling. If we sample \code{k} times, the p-value is calculated as:

\if{html}{\out{<div class="sourceCode">}}\preformatted{p = sum_\{i in 1..k\}(I(sr_i > s))/k
}\if{html}{\out{</div>}}
}
\examples{
\dontrun{
dag = create_ontology_DAG_from_GO_db() 
value = runif(dag_n_terms(dag)) # a set of random values
df = dag_enrich_on_offsprings_by_permutation(dag, value)
}
1
}
