% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich.R
\name{dag_enrich_on_items}
\alias{dag_enrich_on_items}
\alias{dag_enrich_on_genes}
\title{Enrichment analysis on the number of annotated items}
\usage{
dag_enrich_on_items(dag, items, min_hits = 5, min_items = 10)

dag_enrich_on_genes(dag, genes, min_hits = 5, min_genes = 10)
}
\arguments{
\item{dag}{An \code{ontology_DAG} object.}

\item{items}{A vector of item names.}

\item{min_hits}{Minimal number of items in the term set.}

\item{min_items}{Minimal size of the term set.}

\item{genes}{A vector of gene IDs. The gene ID type can be found by directly printing the \code{ontology_DAG} object.}

\item{min_genes}{Minimal number of genes.}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{term}: Term names.
\item \code{n_hits}: Number of items in \code{items} intersecting to \code{t}'s annotated items.
\item \code{n_anno}: Number of annotated items of \code{t}. Specifically for \code{dag_enrich_on_genes()}, this column
is renamed to \code{n_gs}.
\item \code{n_items}: Number of items in \code{items} intersecting to all annotated items in the DAG. Specifically
for \code{dag_enrich_on_genes()}, this column is renamed to \code{n_genes}.
\item \code{n_all}: Number of all annotated items in the DAG.
\item \code{log2_fold_enrichment}: Defined as log2(observation/expected).
\item \code{z_score}: Defined as (observed-expected)/sd.
\item \code{p_value}: P-values from hypergeometric test.
\item \code{p_adjust}: Adjusted p-values from the BH method.
}

The number of rows in the data frame is the same as the number of terms in the DAG.
}
\description{
The analysis task is to evaluate which terms the given items are enriched to.
}
\details{
The function tests whether the list of items are enriched in terms on the DAG.
The test is based on the hypergeometric distribution. In the following 2x2 contigency table, \code{S} is the set of \code{items},
for a term \code{t} in the DAG, \code{T} is the set of items annotated to \code{t} (by automatically merging from its offspring terms),
the aim is to test whether \code{S} is over-represented in \code{T}.

The universal set \code{all} correspond to the full set of items annotated to the DAG.

\if{html}{\out{<div class="sourceCode">}}\preformatted{+----------+------+----------+-----+
|          | in S | not in S | all |
+----------+------+----------+-----+
| in T     |  x11 |    x12   | x10 |
| not in T |  x21 |    x22   | x20 |
+----------+------+----------+-----+
| all      |  x01 |    x02   |  x  |
+----------+------+----------+-----+
}\if{html}{\out{</div>}}

\code{dag_enrich_on_genes()} is the same as \code{dag_enrich_on_items()} which only changes the argument \code{item} to \code{gene}.
}
\examples{
\dontrun{
dag = create_ontology_DAG_from_GO_db(org_db = "org.Hs.eg.db") 
items = random_items(dag, 1000)
df = dag_enrich_on_items(dag, items)
}
1
}
