% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{read_gmt}
\alias{read_gmt}
\title{Read in gene set information from .gmt files}
\usage{
read_gmt(file, start = 1, end = -1)
}
\arguments{
\item{file}{The .gmt file to be read}

\item{start}{integer(1), read the gmt file from start line}

\item{end}{integer(1), read the gmt file to the end line, the default -1 
means read to the end}
}
\value{
A list, where each index represents a separate gene set.
}
\description{
This function reads in and parses information from the MSigDB's .gmt files. 
Pathway information will be returned as a list of gene sets.
}
\details{
The .gmt format is a tab-delimited list of gene sets, where each line is a 
separate gene set. The first column must specify the name of the gene set, 
and the second column is used for a short description (which this function 
discards). For complete details on the .gmt format, refer to the Broad 
Institute's Data Format's page 
\url{http://www.broadinstitute.org/cancer/software/gsea/wiki/index.php/Data_formats}.
}
\section{Warning}{

The function does not check that the file is correctly formatted, and may 
return incorrect or partial gene sets, e.g. if the first two columns are 
omitted. Please make sure that files are correctly formatted before reading 
them in using this function.
}

\examples{
gmt_path <- system.file("extdata/test_gene_sets_n4.gmt", package="signatureSearch")
geneSets <- read_gmt(gmt_path)
}
