% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{qSig-class}
\alias{qSig-class}
\title{Class "qSig"}
\description{
S4 object named \code{qSig} containing query signature information for Gene
Expression Signature (GES) searches. It contains slots for query signature,
GESS method and path to the GES reference database.
}
\section{Slots}{

\describe{
\item{\code{query}}{If 'gess_method' is one of 'CMAP' or 'LINCS', 
this should be a list with two character vectors named \code{upset}
and \code{downset} for up- and down-regulated gene labels (here Entrez IDs),
respectively.

If 'gess_method' is 'gCMAP', 'Fisher' or 'Cor', a single column matrix with
gene expression values should be assigned. The corresponding gene labels 
are stored in the row name slot of the matrix. The expected type of gene 
expression values is explained in the help files of the corresponding GESS 
methods.}

\item{\code{gess_method}}{one of 'CMAP', 'LINCS', 'gCMAP', 'Fisher' or 'Cor'}

\item{\code{refdb}}{character(1), can be "cmap", "cmap_expr", "lincs", "lincs_expr",
or "lincs2" when using existing CMAP/LINCS databases. 

If users want to use a custom database, it should be the file path
to the HDF5 file generated with the \code{\link{build_custom_db}} function.
Alternatively, source files of the CMAP/LINCS databases can be used as
explained in the vignette of the
\code{\link[signatureSearchData]{signatureSearchData}} package.}

\item{\code{db_path}}{character(1), file path to the \code{refdb}}
}}

\keyword{classes}
