% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{parse_gctx}
\alias{parse_gctx}
\title{Parse GCTX}
\usage{
parse_gctx(
  fname,
  rid = NULL,
  cid = NULL,
  set_annot_rownames = FALSE,
  matrix_only = FALSE
)
}
\arguments{
\item{fname}{character(1), path to the GCTX file on disk}

\item{rid}{either a vector of character or integer
row indices or a path to a grp file containing character
row indices. Only these indices will be parsed from the
file.}

\item{cid}{either a vector of character or integer
column indices or a path to a grp file containing character
column indices. Only these indices will be parsed from the
file.}

\item{set_annot_rownames}{boolean indicating whether to set the
rownames on the row/column metadata data.frames. Set this to 
false if the GCTX file has duplicate row/column ids.}

\item{matrix_only}{boolean indicating whether to parse only
the matrix (ignoring row and column annotations)}
}
\value{
gct object
}
\description{
Parse a GCTX file into the R workspace as a GCT object
}
\examples{
gctx <- system.file("extdata", "test_sample_n2x12328.gctx", 
                    package="signatureSearch")
gct <- parse_gctx(gctx)
}
\concept{GCTX parsing functions}
