% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{matrix2h5}
\alias{matrix2h5}
\title{Write Matrix to HDF5 file}
\usage{
matrix2h5(matrix, h5file, name = "assay", overwrite = TRUE)
}
\arguments{
\item{matrix}{matrix to be written to HDF5 file, row and column name slots 
need to be populated}

\item{h5file}{character(1), path to the hdf5 destination file}

\item{name}{The name of the dataset in the HDF5 file. The default is write
the score matrix (e.g. z-score, logFC) to the 'assay' dataset, users could 
also write the adjusted p-value or FDR matrix to the 'padj' dataset by 
setting the \code{name} as 'padj'.}

\item{overwrite}{TRUE or FALSE, whether to overwrite or append
matrix to an existing 'h5file'}
}
\value{
HDF5 file containing exported matrix
}
\description{
Function writes matrix object to an HDF5 file.
}
\examples{
mat <- matrix(rnorm(12), nrow=3, dimnames=list(
              paste0("r",1:3), paste0("c",1:4)))
h5file <- tempfile(fileext=".h5")
matrix2h5(matrix=mat, h5file=h5file, overwrite=TRUE)
}
