% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{feaResult-class}
\alias{feaResult-class}
\title{feaResult object}
\description{
The \code{feaResult} object stores Functional Enrichment Analysis (FEA) 
results generated by the corresponding Target and Drug Set Enrichment 
methods (here TSEA and DSEA) defined by \code{signatureSearch}. This 
includes slots for the FEA results in tabular format, the organism 
information, and the type of functional annotation used (e.g. GO or KEGG). 
It also includes the drug information used for the FEA, as well as the 
corresponding target protein information.
}
\section{Slots}{

\describe{
\item{\code{result}}{tibble object, this tabular result contains the
enriched functional categories (e.g. GO terms or KEGG pathways) ranked by 
the corresponding enrichment statistic. The result table can be extracted 
via the \code{\link{result}} accessor function.}

\item{\code{organism}}{organism information of the annotation system. 
Currently, limited to 'human', since drug-target annotations are too sparse
for other organisms.}

\item{\code{ontology}}{ontology type of the GO annotation system. If the 
annotation system is KEGG, it will be 'KEGG'}

\item{\code{drugs}}{input drug names used for the enrichment test}

\item{\code{targets}}{target information for the query drugs obtained from the 
chosen drug-target annotation source.}
}}

\keyword{classes}
