% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{addGESSannot}
\alias{addGESSannot}
\title{Add Compound Annotation Info to GESS Result Table}
\usage{
addGESSannot(
  gess_tb,
  refdb,
  cmp_annot_tb = NULL,
  by = "pert",
  cmp_name_col = "pert"
)
}
\arguments{
\item{gess_tb}{tibble or data.frame object of GESS result, 
can be accessed by the \code{result} method on the \code{gessResult} object 
from \code{gess_*} functions. Or a customized data frame that contains a 
\code{pert} column that stores compound id or name.}

\item{refdb}{character(1), reference database that can be accessed by 
the \code{refdb} method on the \code{gessResult} object. If \code{gess_tb}
is a customized table, \code{refdb} can be just set as 'custom'.}

\item{cmp_annot_tb}{data.frame or tibble of compound annotation table. 
This table contains annotation information for compounds stored under
\code{pert} column of \code{gess_tb}. Set to \code{NULL} if not available.
This table should not contain columns with names of "t_gn_sym", "MOAss" or 
"PCIDss", these three columns will be added internally and thus conserved by 
the function. If they are contained in \code{cmp_annot_tb}, they will be
overwritten. If users want to maintain these three columns in the provided 
annotation table, give them different names.}

\item{by}{character(1), column name in \code{cmp_annot_tb} that can be merged
with \code{pert} column in \code{gess_tb}. If \code{refdb} is set 
as 'lincs2', it will be merged with \code{pert_id} column in the GESS result 
table. If \code{cmp_annot_tb} is NULL, \code{by} is ignored.}

\item{cmp_name_col}{character(1), column name in \code{gess_tb} or 
\code{cmp_annot_tb} that store compound names. If there is no compound name 
column, set to \code{NULL}. If \code{cmp_name_col} is available, 
three additional columns (t_gn_sym, MOAss, PCIDss) are automatically added 
by using \code{\link{get_targets}}, CLUE touchstone compound MOA annotation, 
and 2017 \code{lincs_pert_info} annotation table, respectively as 
annotation sources. t_gn_sym: target gene symbol, MOAss: MOA annotated from 
signatureSearch, PCIDss: PubChem CID annotated from signatureSearch.}
}
\value{
tibble of \code{gess_tb} with target, MOA, PubChem CID annotations
and also merged with user provided compound annotation table.
}
\description{
This function supports adding customized compound annotation table to the 
GESS result table if provided. It then automatically adds the target gene
symbols, MOAs and PubChem CID columns (\code{t_gn_sym}, \code{MOAss}, 
\code{PCIDss}) if the table contains a column that stores compound names.
}
\examples{
gess_tb <- data.frame(pert=c("vorinostat", "sirolimus", "estradiol"),
                  cell=c("SKB", "SKB", "MCF7"),
                  NCS=runif(3))
cmp_annot_tb <- data.frame(pert_name=c("vorinostat", "sirolimus", "estradiol"),
                           prop1=c("a", "b", "c"),
                           prop2=1:3)
addGESSannot(gess_tb, "custom", cmp_annot_tb, by="pert_name", 
             cmp_name_col="pert")
}
