% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScatter.R
\name{plotScatter}
\alias{plotScatter}
\title{Scatter plot}
\usage{
plotScatter(plotMatrix, repIndex, plotRows = NULL, plotCols = NULL,
  plotName = NULL, ...)
}
\arguments{
\item{plotMatrix}{Data frame or numeric matrix. Columns are plates, and rows are plate wells.}

\item{repIndex}{Optional. Vector of labels indicating replicate group. Each index in the vector matches the corresponding column of plotMatrix. If NULL then all plates are plotted together without grouping.}

\item{plotRows, plotCols}{Optional integer vector. Indicate which row/column numbers from the plotMatrix should be plotted. If NULL then all rows/columns from the plotMatrix are used.}

\item{plotName}{Optional. Name of plotMatrix for plot title.}

\item{...}{Optional. Additional parameters passed to \code{\link[ggplot2]{geom_point}}.}
}
\value{
List of modifiable ggplot2 objects
}
\description{
Construct a scatter plot of all pairwise combinations of replicates
}
\details{
Scatter plots with robust regression lines of replicate plates can reveal a kind of bias which acts independently of within-plate biases and which cannot be detected by heat maps (\code{\link{plotHeatmap}}) or auto-correlation plots (\code{\link{plotAutoco}}). A mixture of active and inactive features should produce a zero-correlation flat regression line within most of the range and a positively sloped line within the active range(s) at the extreme(s) of the distribution.
}
\examples{
## load dataset
data(ex_dataMatrix)

## plot raw data
plotScatter(plotMatrix = ex_dataMatrix, repIndex = c(1,1,1), plotCols = 5:7,
plotName = 'Example')
## normalize data matrix using any method and store in new variable
ex_normMatrix <- normZ(dataMatrix = ex_dataMatrix, dataCols = 5:10)
## plot normalized data
plotScatter(plotMatrix = ex_normMatrix, repIndex = c(1,1,1), plotCols = 1:3,
plotName = 'Example')

}
\seealso{
Other graphical devices: \code{\link{plot3d}},
  \code{\link{plotAutoco}}, \code{\link{plotBox}},
  \code{\link{plotHeatmap}}, \code{\link{plotHist}},
  \code{\link{plotIGFit}}
}

